void PlaySound (const u16* DataPtr);
void StopSound (unsigned char SoundIndex);
void StopAllSounds ();
void PauseAllSounds ();
void DoSounds ();
void InitSound ();

// Special sound notes
#define ENDSOUND  0xFFFF  // Ends the sound.
#define LOOPSOUND 0xFFFE  // Repeats the sound from the beginning.

// Maximum number of sounds
#define kMaxSounds 4  // No point in changing this (and 4 is the max).

// Sound property structure
typedef struct
{
  u16* StartPtr;           // Start of data (nonzero if the sound is playing)
  unsigned int NoteIndex;  // Index of current note, begins at 1
  u8 FramesPerNote;        // How many video frames each note lasts.
  u8 FramesLeft;           // How many video frames until next note.
} tySound;

// Sound array
tySound Sound[kMaxSounds];

// Sound modulation data
const u8 kModData[] = {
  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21, -1, -2, -3, -4, -5,
  -6, -7, -8, -9, -16, -17, -18, -19, -20, -21, -22
};
